// // // // // // // // // // // // // // // //
//
//	Enemy Terriotry - ClientWelt.cc
//
//	erstellt 3.2.98 Andreas Warnke
//	geändert 23.2.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "ClientWelt.h"
#include "Paradise.h"
#include "Ebene.h"
#include "Definitions.h"
#include "AsciiKette.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

ClientWelt :: ClientWelt ( int inSize, unsigned int inID, Ebene * inEbene )
	: Scout ( inSize )
{
	//	ID zuweisen:
	DieID = inID;
	//	Ebene zuweisen:
	DieEbene = inEbene;
	
	ServerTime = 1;
	EqualClientTime = 1;
		
	//	Name und Passwort:
	DerName = NULL;
	DasPasswort = NULL;
};



// // // // // // // // // // // // //
//
//	Destruktor:
//

ClientWelt :: ~ClientWelt ()
{
	//	Name und PAssowrt löschen:
	if ( DerName != NULL )
	{
		delete [] DerName;
		DerName = NULL;
	};
	if ( DasPasswort != NULL )
	{
		delete [] DasPasswort;
		DasPasswort = NULL;
	};	
};



// // // // // // // // // // // // //
//
//	GetLatestObject:
//

Objekt * ClientWelt :: GetLatestArmy ( int inX, int inY)
{
	if ( GetFieldType ( inX, inY ) == FT_EndOfWorld )
		//	(inX,inY) nicht auf der Karte.
		return NULL;

	if ( ObjektFeld == NULL )
	{
		//	ObjektFeld existiert nicht.
		//	Unexpected error
		return NULL;
	};
		
	ElementList & sPosListe = ObjektFeld [ inX + Karte :: Width * inY ];
	
	//	Zeiger auf beste Alternative:
	Objekt * sBest = NULL;
	bigtime_t sCurrentTime = ServerTime;
	
	//	Durchsuche Liste:
	int sPos = sPosListe . CountElements ();
	while ( sPos > 0 )
	{
		sPos--;
		Objekt * sFinger = (Objekt*) ( sPosListe . GetElement ( sPos ) );
		
		bool better = true;
		
		//	wenn sFinger fremdes Objekt, dann ist es nicht besser!
		if ( sFinger -> BelongsTo != DieID )
			better = false;

		//	wenn sFinger keine Armee, dann ist es nicht besser!
		if ( ( sFinger -> Typ & Obj_TypeMask ) != Obj_Figur )
			better = false;

		if ( ( sBest != NULL ) && better )
		{
			//	es gibt eine Alternative (ioBest).
			//	Berechne, welche Objekte noch beschäftigt sind:
			bool bestBusy = ( sBest -> BusyTill > sCurrentTime );
			bool thisBusy = ( sFinger -> BusyTill > sCurrentTime );
			if ( bestBusy)
				if ( thisBusy)
					better = ( sFinger -> BusyTill < sBest -> BusyTill );
				else
					better = true;				
			else
				if ( thisBusy)
					better = false;
				else
					better = ( sFinger -> BusyTill > sBest -> BusyTill );			 
		};
	
		if ( better)
			sBest = sFinger;
	};
		
	//	Fertig:
	return sBest;
};



// // // // // // // // // // // // // // // //
//
//	Error
//

void ClientWelt :: Error ( const char * inText )
{
	DieEbene -> ErrorAlert ( inText );
};



// // // // // // // // // // // // //
//
//	MoveArmy:
//

void ClientWelt :: MoveArmy ( unsigned int inID, int inToX, int inToY )
{
	//	Erstellen der Message:
	BMessage dieNachricht ( Msg_InterApplicationMessage );	
	dieNachricht . AddString( "Type", "turn");
	dieNachricht . AddString( "ClientName", DerName);
	dieNachricht . AddString( "Password", DasPasswort);
	dieNachricht . AddInt32( "ID", inID);
	dieNachricht . AddString( "Action", "move");
	dieNachricht . AddInt32( "MoveToX", inToX);
	dieNachricht . AddInt32( "MoveToY", inToY);
	
	//	Message verschicken:
	if ( ServerTeam . IsValid() )
		ServerTeam . SendMessage ( & dieNachricht );
	else
		Error( "I'm sorry, but there's no server any more.");			
};



// // // // // // // // // // // // //
//
//	Build Village:
//

void ClientWelt :: BuildVillage ( unsigned int inID )
{
	//	Erstellen der Message:
	BMessage dieNachricht ( Msg_InterApplicationMessage );	
	dieNachricht . AddString( "Type", "turn");
	dieNachricht . AddString( "ClientName", DerName);
	dieNachricht . AddString( "Password", DasPasswort);
	dieNachricht . AddInt32( "ID", inID);
	dieNachricht . AddString( "Action", "build");
	
	//	Message verschicken:
	if ( ServerTeam . IsValid() )
		ServerTeam . SendMessage ( & dieNachricht );
	else
		Error( "I'm sorry, but there's no server any more.");			
};



// // // // // // // // // // // // // // // //
//
//	GetServerTime
//

bigtime_t ClientWelt :: GetServerTime ()
{
	return ( ServerTime + ( real_time_clock_usecs() - EqualClientTime ) );
};



// // // // // // // // // // // // // // // //
//
//	InfoWindow
//

void ClientWelt :: InfoWindow ( int inX, int inY )
{
	//	Ermittle Feld-Daten:
	int sTyp = GetFieldType ( inX, inY );
	bool sInvisible = ( sTyp & FT_ShadowMask ) || ( sTyp == FT_Undiscovered );	
	sTyp = sTyp & FT_TypeMask;
	const char * sTypeString;
	if ( sTyp == FT_EndOfWorld )
		sTypeString = "End of world";
	else if ( sTyp == FT_Undiscovered )
		sTypeString = "Undiscovered";
	else if ( ( sTyp >= FT_Sea ) && ( sTyp < FT_Sea + FI_Sea ) )
		sTypeString = "Lake";
	else if ( ( sTyp >= FT_Plain ) && ( sTyp < FT_Plain + FI_Plain ) )
		sTypeString = "Plain";
	else if ( ( sTyp >= FT_Mountain ) && ( sTyp < FT_Mountain + FI_Mountain ) )
		sTypeString = "Mountain";
	else if ( ( sTyp >= FT_Forrest ) && ( sTyp < FT_Forrest + FI_Forrest ) )
		sTypeString = "Forrest";
	else 
		sTypeString = "Unknown type !?";
	char * sTimeToCross;
	bigtime_t sDelay = GetFieldDelay ( inX, inY );
	if ( ( sDelay < FD_NoWay ) && ( sTyp != FT_Undiscovered ) )
		sTimeToCross = ConcatAndDeleteOdd (
			IntToString ( sDelay / 1000000 ), " seconds\n" );
	else
		sTimeToCross = Concat ( "-\n", NULL );
		
	//	Ermittle Objektdaten:
	bigtime_t sNextReady = 1;
	int sArmyCount = 0;
	int sVillageCount = 0;
	unsigned int sOwnerID = 0;
	if ( ObjektFeld != NULL )
	{
		ElementList * sListe = & ObjektFeld [ inX + Width * inY ];
		for ( int i = 0; i < sListe -> CountElements (); i++ )
		{
			Objekt * sFinger = (Objekt*) sListe -> GetElement ( i );
			sOwnerID = sFinger -> BelongsTo;
			if ( ( sFinger -> Typ & Obj_TypeMask ) == Obj_Figur )
				sArmyCount ++;
			else if ( ( sFinger -> Typ & Obj_TypeMask ) == Obj_Dorf )
			{
				sVillageCount ++;
				if ( ( sNextReady == 1 ) || ( sNextReady > sFinger -> BusyTill ) )
					sNextReady = sFinger -> BusyTill;
			};
		};
	};
	sNextReady = sNextReady - GetServerTime ();
	if ( sNextReady < 0 )
		sNextReady = 0;
	
	//	Generiere Feld - String:
	char * sText = ConcatAndDeleteEven (
		"Field at (",
		IntToString ( inX ),
		",",
		IntToString ( inY ) );
	sText = ConcatAndDeleteOdd (
		sText, ")\n"
		"    Type: ", NULL, sTypeString );
	sText = ConcatAndDeleteOdd (
		sText, " (", Int8ToHexString ( sTyp ), ")\n"
		"    Delay: " );
	sText = ConcatAndDeleteOdd (
		sText,
		NULL,
		 sTimeToCross, "\n" );
		 
	//	Generiere ObjektString:
	if ( sInvisible )
		//	Invisible
		sText = ConcatAndDeleteOdd (
			sText,
			"Objects aren't visible.\n" );
	else if ( sOwnerID == 0 )
		//	Empty
		sText = ConcatAndDeleteOdd (
			sText,
			"There are no objects on this field.\n" );
	else
	{
		//	Objects exist
		if ( sOwnerID == 1 )
			//	Natives
			sText = ConcatAndDeleteOdd (
				sText,
				"Objects on this field:\n"
				"    Owner ID: 1 (Natives)\n" );
		else if ( sOwnerID == DieID )
			//	Own objects
			sText = ConcatAndDeleteOdd (
				sText,
				"Objects on this field:\n"
				"    Owner ID: ", IntToString ( sOwnerID ), " (You)\n" );
		else
			//	Enemy:
			sText = ConcatAndDeleteOdd (
				sText,
				"Objects on this field:\n"
				"    Owner ID: ", IntToString ( sOwnerID ), "\n" );
		sText = ConcatAndDeleteOdd (
			sText,
			"    Armies: ", IntToString ( sArmyCount ), "\n" );
		sText = ConcatAndDeleteOdd (
			sText,		
			"    Cities: ", IntToString ( sVillageCount ), "\n");
		if ( sVillageCount != 0 )
			sText = ConcatAndDeleteOdd (
				sText,		
				"    Next army is ready in ", IntToString ( sNextReady / 1000000 ), " secs.\n" );
	};
	
	//	Alert:
	BAlert * TheInfo = new BAlert (
		"GetInfoWindow",
		sText,
		"ok" );
	if ( TheInfo != NULL )
		TheInfo -> Go ( NULL );
		
	//	Speicher freigeben:
	if ( sText != NULL )
		delete [] sText;
};



//
//	Ende
//
// // // // // // // // // // // // // // // //